<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserOrder extends Model
{
    protected $fillable = [
        'user_id',
        'order_id',
        'status',
        'price',
        'type',
        'payment_type',
        'country',
        'plan_id',
        'tax_rate',
        'tax_value',
        'payload',
        'affiliate_earnings'
    ];

    protected $guarded = [];

    protected $casts = [
        'payload' => 'array',
    ];

    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
