<?php

    namespace App\Http\Controllers;

    use App\Http\Controllers\PaymentController;
    use App\Models\Plan;
    use Illuminate\Http\Request;
    use Telegram\Bot\Api;
    use App\Http\Controllers\ActionsBotController;
    use App\Models\BotPrompt;
    use App\Models\ChatStatus;
    use App\Models\User;
    use App\Models\UserOpenai;
    use App\Models\OpenAIGenerator;
    use Illuminate\Support\Facades\Crypt;
    use Illuminate\Support\Facades\Hash;


    class ProssesMessageController extends Controller
    {
//    protected $telegram;

        public function prosses(Request $request, $message)
        {
            $telegram = new Api(env('TELEGRAM_BOT_API_TOKEN'));
            $update = $telegram->getWebhookUpdate();
            $userInfo = $update->getMessage();
            $userId = $userInfo->getFrom()->getId();
            $username = $userInfo->getFrom()->getUsername();
            $firstName = $userInfo->getFrom()->getFirstName();
            $lastName = $userInfo->getFrom()->getLastName();
            $chatId = $update->getMessage()->getChat()->getId();
            $text = $update->getMessage()->getText();
            $user = null;
            $actionBot = new ActionsBotController();
            $payMent = new PaymentController();
            $data = $request->all();

            $userData = getUserDataFromTelegram();

            if (isset($update['callback_query'])) {
                $callbackData = $update['callback_query']['data'];
                $chatId = $update['callback_query']['message']['chat']['id'];
                $messageId = $update['callback_query']['message']['message_id'];

                if ($callbackData == 'check_membership') {
                    if (isUserMember($userData['chatId'])) {
                        sendMessageToTelegram([
                            'chat_id' => $chatId,
                            'message_id' => $messageId,
                            'text' => "شما عضو کانال هستید!",
                        ]);
                        die();
                        // ادامه عملیات
                    } else {
                        sendToAsk($userData['chatId']);
                    }
                }
            }

            if ($userInfo && isset($text) && strpos($text, '/start') === 0) {

                $referrerId = substr($text, 6);  // گرفتن شناسه ارجاع (بعد از "/start=")
                if ($referrerId) {

                    // $referrerId = Crypt::decryptString($referrerId);

                    $user = User::where('facebook_id', $userId)->where('affiliate_status', 1)->first();


                    if (!$user) {
                        $password = 1234;
                        $user2 = User::where('facebook_id', $userId)->where('affiliate_status', 2)->first();

                        if ($user2) {
                            $user2->delete();
                            $user = User::create([
                                'facebook_id' => $userId,
                                'surname' => $firstName,
                                'name' => '',
                                'email' => $userId . "@NevisaBot.com",
                                'password' => Hash::make($password),
                                'team_id' => $referrerId,
                                'entity_credits' => 100
                            ]);
                        } else {

//                     $telegram->sendMessage([
//                                   'chat_id' => $chatId,
//                                   'text' => 'dsasdas',
//                               ]);
//                               die();
                            $user = User::create([
                                'facebook_id' => $userId,
                                'surname' => $firstName,
                                'name' => '',
                                'email' => $userId . "@NevisaBot.com",
                                'password' => Hash::make($password),
                                'team_id' => $referrerId,
                                'entity_credits' => 100
                            ]);
                        }


                        $referrerUser = User::where('team_id', $referrerId)->where('affiliate_status', 1)->first();

                        $result = "شما توسط کابر دیگری ب نام $referrerUser->surname به ربات دعوت شده اید (¬‿¬)" . "\n\n";
                        $result .= "امتاز شما $user->entity_credits افزایش یافت :))";
                        // die();

                        $telegram->sendMessage([
                            'chat_id' => $chatId,
                            'text' => $result
                        ]);
                        // die();

                        $improveCredits = User::where('facebook_id', $referrerUser->team_id)->where('affiliate_status', 1)->first();
                        if (!$user2) {
                            if ($improveCredits) {
                                if (!empty($improveCredits->entity_credits)) {

                                    $entity_credits = $improveCredits->entity_credits + 200;

                                    $improveCredits->update([
                                        'entity_credits' => $entity_credits
                                    ]);

                                } else {
                                    $improveCredits->update([
                                        'entity_credits' => 200
                                    ]);
                                }
                            }
                        }


                        if ($user) {
                            return $actionBot->startMessage($request, $user->name);
                        } else {
                            $telegram->sendMessage([
                                'chat_id' => $chatId,
                                'text' => 'invalid in register !!!'
                            ]);
                        }
                    } else {
                        // $telegram->sendMessage([
                        //     'chat_id' => $chatId,
                        //     'text' => 'ssss',
                        // ]);
                        // die();
                        return $actionBot->startMessage($request, $userId);

                    }
                } else {

                    $user1 = User::where('facebook_id', $userId)->where('affiliate_status', 1)->first();
                    if ($user == null) {

                        $user2 = User::where('facebook_id', $userId)->where('affiliate_status', 2)->first();
                        if ($user2) {
                            $user2->delete();
                            return $actionBot->startMessage($request, $userId);
                            // $telegram->sendMessage([
                            //     'chat_id' => $chatId,
                            //     'text' => "Hi",
                            // ]);
                            // die();
                        } else {
                            return $actionBot->startMessage($request, $userId);
                        }
                    }

                }
            }


            if (isUserMember($userData['chatId'])) {

//                if (isset($update['callback_query'])) {
//                    $callbackData = $update['callback_query']['data'];
//                    $chatId = $update['callback_query']['message']['chat']['id'];
//                    $messageId = $update['callback_query']['message']['message_id'];
//                    if($callbackData == 'next_page'){
//                        return $actionBot->showProfile();
//                        exit();
//                    }
//                }

                if (isset($update['callback_query'])) {
                    $callbackData = $update['callback_query']['data'];
                    $chatId = $update['callback_query']['message']['chat']['id'];
                    $messageId = $update['callback_query']['message']['message_id'];
                    $paymentController = new PaymentController();
                    $toneOfVoices = [
                        'Professional',
                        'Funny',
                        'Casual',
                        'Excited',
                        'Witty',
                        'Sarcastic',
                        'Feminine',
                        'Masculine',
                        'Bold',
                        'Dramatic',
                        'Grumpy',
                        'Secretive',
                    ];

                    if(in_array($callbackData, $toneOfVoices)){
                        $telegram->sendMessage([
                            'chat_id' => $chatId,
                            'text' => $callbackData,
                        ]);
                        die();
                    }elseif($callbackData == 'cancel'){
                        return $actionBot->showProfile();
                        exit();
                    }


                    if($callbackData == 'back_page'){
                        return $actionBot->packagesList();
                        exit();
                    }
                }

                $user = User::where('facebook_id', $userId)->where('affiliate_status', 1)->first();

                $openAIFilters = OpenAIGenerator::all()->groupBy('filters');
                $openAITitle = OpenAIGenerator::all()->groupBy('title');
                $namePlans = Plan::all()->groupBy('name');
                foreach ($namePlans as $key => $value) {
                    $namePlan[] = $key;
                }
                foreach ($openAITitle as $key => $value) {
                    $title[] = $key;
                }
                foreach ($openAIFilters as $key => $value) {
                    $fiter[] = $key;
                }

                if(in_array($message, $namePlan)){
                    return $actionBot->packageDetails($message);
                    exit();
                }


                if (in_array($message, $title)) {
                    $openAI = OpenAIGenerator::where('title', $message)->first();
                    $userOpenai = UserOpenai::where('user_id', $user->id)->where('openai_id', $openAI->id)->latest()->first();

                } else {

                    $userOpenai = UserOpenai::where('user_id', $user->id)->latest()->first();
                }

                if ($message == 'ویرایش نام' || $message == 'ویرایش تلفن') {
                    return $actionBot->editProfile($message);
                }

                if ($user->status == 0) {
                    switch ($message) {
                        case 'بله' :
                            return $actionBot->deleteAccount($message);
                            break;
                        case 'خیر' :
                            return $actionBot->deleteAccount($message);
                            break;
                    }
                }

                if ($user->status == 2) {
                    return $actionBot->updateNameProfile($message);
                }

                if ($user->status == 3) {
                    if (is_numeric($message)) {
                        return $actionBot->updatePhoneProfile($message);
                    } else {
                        $telegram->sendMessage([
                            'chat_id' => $chatId,
                            'text' => 'شماره تلفن فقط باید عدد باشد !!'
                        ]);
                        exit();
                    }
                }

                if ($user->status == 4) {
                    return $actionBot->updateEmailProfile($message);

                }

                if ($userOpenai) {
                    if ($userOpenai->status == "PENDING...") {
                        switch ($message) {
                            case "Accept":
                                return $actionBot->answer($message);
                                break;
                            case "Cancel":
//                            sendMessageToTelegram([
//                                'chat_id' => $chatId,
//                                'text' => 'hi',
//                            ]);
//                            die();
                                return $actionBot->answer($message);
                                break;
                            case "Edit":
                                return $actionBot->answer($message);
                                break;
                            default :
                                $telegram->sendMessage([
                                    'chat_id' => $chatId,
                                    'text' => 'ابتدا این مرحله را تکمیل کنید !!'
                                ]);
                                break;
                        }

                        exit();
                    }

                }

                if ($userOpenai) {
                    if ($userOpenai->status == 0) {
                        if ($message) {
                            return $actionBot->getData($message);
                        }
                    } elseif ($userOpenai->status == "UPDATING") {
                        if ($message) {
                            return $actionBot->updateUserOpenAiData($message);
                        }
                    }
                }

                if ($message == 'لحن' || $message == 'زبان' || $message == 'نسخه هوش مصنوعی' ){
                    return $actionBot->editDefultePromptSetting($message);
                }

                switch ($message) {
                    case "Return":
                        return $actionBot->startMessage($request, $userId);
                        break;
                    case "Back":
                        return $actionBot->categoryMessage();
                        break;
                    case "/start":
                        return $actionBot->startMessage($request, $userId);
                        break;
                    case "ساخت پرامت":
                        return $actionBot->categoryMessage();
                        break;
                    case "افزایش اعتبار":
                        return $actionBot->packagesList();
                        break;
                    case "مشاهده پروفایل":
                        return $actionBot->showProfile();
                        break;
                    case "حذف حساب کاربری":
                        return $actionBot->approveDeleteAccount();
                        break;
                        case "تنظیمات پرامت":
                        return $actionBot->promptSetting();
                        break;
                    case "دعوت دوستان":
                        return $actionBot->invitedLink();
                        break;
                    case "مشاهده پرامت ها":
                        return $actionBot->promptList();
                        break;
                    case in_array($message, $fiter):
                        return $actionBot->titleOfCategory($message);
                        break;
                    case in_array($message, $title):
                        return $actionBot->getTitle($message);
                        break;
                    default:
                        $telegram->sendMessage([
                            'chat_id' => $chatId,
                            'text' => "برای این کلمه هیچ عملیات وجود ندارد  :-("
                        ]);
                        die();
                        break;
                }


            } else {
//                     $telegram->sendMessage([
//                         'chat_id' => $chatId,
//                         'text' => 'test'
//                     ]);
//                     die();

                sendToAsk($userData['chatId']);
            }
        }
    }

