<?php

namespace App\Http\Controllers;

use App\Models\Plan;
use App\Models\User;
use App\Models\UserOrder;
use Illuminate\Http\Request;
use Telegram\Bot\Api;
use Shetabit\Multipay\Payment;
use Shetabit\Multipay\Invoice;
use Shetabit\Multipay\Exceptions\InvalidPaymentException;

class PaymentController extends Controller
{

    public function generatePaymentLink($requestParams = []) {
        // لیست درگاه های معتبر
//        dd($requestParams);

        $userData = getUserDataFromTelegram();
        $validGateways = ['mellat','melli','zarinpal'];
        // چون فعلا درگاه زرین پال رو تنها داریم، فعلا مقدار درگاه رو روی زرین پال قرار میدیم
        $requestParams['gateway']= 'zarinpal' ;
        // در صورتی که درگاه انتخابی جزو درگاه های معتبر ما بود
        if(in_array($requestParams['gateway'],$validGateways))
        {
            // در صورتی که درگاه انتخاب شده زرین پال باشه، متد مربوط به ایجاد لینک زرین پال رو صدا بزن
            if($requestParams['gateway'] == 'zarinpal')
            {
                $paymentLink = $this->generateZarinpalLink($requestParams);
            }
        }
        
        return $paymentLink;
    }

    public function callback(Request $request) {

        $paymentConfig = require(base_path().'/config/payment.php');
        // اطلاعات فایل payment.php رو به عنوان ورودی به کلاس payment ارسال می کنیم.
        $payment = new Payment($paymentConfig);

        $transactionId = $request->input('Authority');
        $userOrder = UserOrder::where('order_id', $transactionId)->first();

        if($userOrder->payment_type == 'zarinpal'){
            $this->zarinpalCallback($userOrder);
        }
         

    }

    /********************************** create zarinpal link **********************************/
    private function generateZarinpalLink($params) {
        $userData = getUserDataFromTelegram();
        // برای این که اطلاعات کانفیگ رو از داخل فایل payment داخل پوشه کانفیگ لاراول بخونه، اطلاعات اون رو داخل یک متغیر قرار میدیم و به کلاس payment ارسال می کنیم.
        $paymentConfig = require(base_path().'/config/payment.php');
        // اطلاعات فایل payment.php رو به عنوان ورودی به کلاس payment ارسال می کنیم.
        $payment = new Payment($paymentConfig);
        $plan = Plan::where('name', $params['packageName'])->first();
        $user = User::where('facebook_id', $userData['userid'])->first();
        // مبلغ دریافت شده از داخل اطلاعات جدول پکیج ها
        $price = $plan->price;

        // دریافت مقدار userid از اطلاعات داده شده توسط ربات تلگرام
        $userid = $user->id;

        $package_id = $plan->id;
        // مشخص کردن مبلغ مورد نیاز برای پرداخت کاربر
        $invoice = (new Invoice)->amount($price);

        // print_r($payment->via('zarinpal'));die();

        $paymentLink = $payment->via('zarinpal')->purchase(
            $invoice,
            function($driver, $transactionId) use ($package_id,$price,$userid) {
                // We can store $transactionId in database.
//        sendMessageToTelegram([
//            'chat_id' => $userid,
//            'text' =>$transactionId . '  ' . $package_id . '  ' . $price
//        ]);
//        die();
                $userOrder = UserOrder::create([
                    'user_id' => $userid,
                    'plan_id' => $package_id,
                    'price' => $price,
                    'order_id' => $transactionId,
                    'payment_type' => 'zarinpal',
                    'country' => 'Iran',
                ]);
        	}
        )->pay()->toJson();

        return json_decode($paymentLink)->action;
    }
    
    /********************************** end create zarinpal link **********************************/
    
    /********************************** create zarinpal callback **********************************/
    private function zarinpalCallback($params)
    {
        $user = User::where('id', $params->user_id)->first();

        try {
            // برای این که اطلاعات کانفیگ رو از داخل فایل payment داخل پوشه کانفیگ لاراول بخونه، اطلاعات اون رو داخل یک متغیر قرار میدیم و به کلاس payment ارسال می کنیم.
            $paymentConfig = require(base_path().'/config/payment.php');
            // اطلاعات فایل payment.php رو به عنوان ورودی به کلاس payment ارسال می کنیم.
            $payment = new Payment($paymentConfig);
            // برای این که اطلاعات کانفیگ رو از داخل فایل payment داخل پوشه کانفیگ لاراول بخونه، اطلاعات اون رو داخل یک متغیر قرار میدیم و به کلاس payment ارسال می کنیم.

            $amount = $params->price;
            // تایید پرداخت
            // ایجاد فاکتور
            $invoice = new Invoice();
            $invoice->amount($amount);

            // تأیید پرداخت
            $receipt = $payment->via('zarinpal')->amount($amount)->transactionId($params->order_id)->verify();

            if($receipt->getReferenceId()){
                $userOrderUpdate = UserOrder::where('order_id', $params->order_id)->update([
                    'status' => 'Approved',
                    'type' => 'prepaid',
                    'payload' => $receipt->getReferenceId()
                ]);

                $userModelEntity = $user->entity_credits;

                $getPlan = Plan::where('id', $params->plan_id)->first();
                $planModel = $getPlan->ai_models;


                if($userModel->entity_credits == null)
                {
                    $user->update(['entity_credits'=>$planModel]);
                }else
                {
                    // openai credit
                    foreach($planModel['openai'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['openai'][$openAiKey]))
                        {
                            $planModel['openai'][$openAiKey]['credit'] = $userModelEntity['openai'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // deep_seek credit
                    foreach($planModel['deep_seek'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['deep_seek'][$openAiKey]))
                        {
                            $planModel['deep_seek'][$openAiKey]['credit'] = $userModelEntity['deep_seek'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // stable_diffusion credit
                    foreach($planModel['stable_diffusion'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['stable_diffusion'][$openAiKey]))
                        {
                            $planModel['stable_diffusion'][$openAiKey]['credit'] = $userModelEntity['stable_diffusion'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // anthropic credit
                    foreach($planModel['anthropic'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['anthropic'][$openAiKey]))
                        {
                            $planModel['anthropic'][$openAiKey]['credit'] = $userModelEntity['anthropic'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // gemini credit
                    foreach($planModel['gemini'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['gemini'][$openAiKey]))
                        {
                            $planModel['gemini'][$openAiKey]['credit'] = $userModelEntity['gemini'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // unsplash credit
                    foreach($planModel['unsplash'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['unsplash'][$openAiKey]))
                        {
                            $planModel['unsplash'][$openAiKey]['credit'] = $userModelEntity['unsplash'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // pexels credit
                    foreach($planModel['pexels'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['pexels'][$openAiKey]))
                        {
                            $planModel['pexels'][$openAiKey]['credit'] = $userModelEntity['pexels'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // pixabay credit
                    foreach($planModel['pixabay'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['pixabay'][$openAiKey]))
                        {
                            $planModel['pixabay'][$openAiKey]['credit'] = $userModelEntity['pixabay'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // elevenlabs credit
                    foreach($planModel['elevenlabs'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['elevenlabs'][$openAiKey]))
                        {
                            $planModel['elevenlabs'][$openAiKey]['credit'] = $userModelEntity['elevenlabs'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // google credit
                    foreach($planModel['google'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['google'][$openAiKey]))
                        {
                            $planModel['google'][$openAiKey]['credit'] = $userModelEntity['google'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // azure credit
                    foreach($planModel['azure'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['azure'][$openAiKey]))
                        {
                            $planModel['azure'][$openAiKey]['credit'] = $userModelEntity['azure'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // serper credit
                    foreach($planModel['serper'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['serper'][$openAiKey]))
                        {
                            $planModel['serper'][$openAiKey]['credit'] = $userModelEntity['serper'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // perplexity credit
                    foreach($planModel['perplexity'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['perplexity'][$openAiKey]))
                        {
                            $planModel['perplexity'][$openAiKey]['credit'] = $userModelEntity['perplexity'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // clipdrop credit
                    foreach($planModel['clipdrop'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['clipdrop'][$openAiKey]))
                        {
                            $planModel['clipdrop'][$openAiKey]['credit'] = $userModelEntity['clipdrop'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // plagiarism_check credit
                    foreach($planModel['plagiarism_check'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['plagiarism_check'][$openAiKey]))
                        {
                            $planModel['plagiarism_check'][$openAiKey]['credit'] = $userModelEntity['plagiarism_check'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // synthesia credit
                    foreach($planModel['synthesia'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['synthesia'][$openAiKey]))
                        {
                            $planModel['synthesia'][$openAiKey]['credit'] = $userModelEntity['synthesia'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // heygen credit
                    foreach($planModel['heygen'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['heygen'][$openAiKey]))
                        {
                            $planModel['heygen'][$openAiKey]['credit'] = $userModelEntity['heygen'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // pebblely credit
                    foreach($planModel['pebblely'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['pebblely'][$openAiKey]))
                        {
                            $planModel['pebblely'][$openAiKey]['credit'] = $userModelEntity['pebblely'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }

                    // fal_ai credit
                    foreach($planModel['fal_ai'] as $openAiKey => $openAi)
                    {
                        if(isset($userModelEntity['fal_ai'][$openAiKey]))
                        {
                            $planModel['fal_ai'][$openAiKey]['credit'] = $userModelEntity['fal_ai'][$openAiKey]['credit'] += $openAi['credit'];
                        }
                    }
                }

                $user->update(['entity_credits'=>$planModel]);
//                dd($receipt->getReferenceId());
                sendMessageToTelegram([
                    'chat_id' => $user->facebook_id,
                    'text' => "پرداخت شما با موفقیت انجام شد. شماره پیگیری: " . $receipt->getReferenceId()
                ]);
            }
//
        }
        catch (InvalidPaymentException $exception) {
             sendMessageToTelegram([
                 'chat_id' => $user->facebook_id,
                 'text' => "پرداخت ناموفق بود. خطا " . $exception->getMessage()
             ]);

//            dd($exception->getMessage());
        }
    }
}
