<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Telegram\Bot\Api;
use Telegram\Bot\Keyboard\Keyboard;
use App\Models\Prompt;
use App\Models\User;
use App\Models\OpenAIGenerator;
use App\Models\ChatStatus;
use Telegram\Bot\Objects\Message;
use Telegram\Bot\Objects\InlineKeyboardMarkup;
use Illuminate\Support\Facades\Hash;
use App\Models\UserOpenai;
use Illuminate\Support\Facades\Crypt;
use App\Models\Plan;
use App\Http\Controllers\PaymentController;



class ActionsBotController extends Controller
{


    
    public function startMessage(Request $request, $userId)
    {
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        // بررسی می کنیم که کاربری با آی دی دریافت شده در داخل دیتابیس وجود داره
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first();
        // در صورتی که کاربر ثبت نام شده وجود داشته باشه
        if($user){
//        $userData = getUserDataFromTelegram();
//
//        sendMessageToTelegram([
//            'chat_id' => $userData['chatId'],
//            'text' => "Hi",
//        ]);
//        die();
            // لیست دکمه های پرامپت برای نمایش به کاربر
            $keyboard = [
                ['ساخت پرامت', 'مشاهده پروفایل'],  // سطر اول دکمه ها
                ['افزایش اعتبار', 'دعوت دوستان']  // سطر دوم دکمه ها
            ];
            
            // متن پیامی که بعد از زدن دکمه start به کاربری که از قبل ثبت نام شده بوده نمایش داده میشه
            $action = $userData['firstName'] . ',' . " به ربات نویسا خوش امدید :)" . "\n\n";
            
            // if(!empty($user->team_id)){
            //     $action .= 'امتیاز شما 10 ستاره افزایش یافت :))';
            // }
                
            $action .= 'برای شروع یکی از دکمه های زیر را انتخاب کنید';
            
            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست

            if(!isUserMember($userData['chatId'])){
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => $action,
                ];

                sendMessageToTelegram($telegramSendMessageParams);

                handleForCheckSubscribers($request);
                exit();
            }else{
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => $action,
                    'reply_markup' => json_encode([
                        'keyboard' => $keyboard,
                        'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                        'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                    ])
                ];

                sendMessageToTelegram($telegramSendMessageParams);
                exit();
            }



            
            // ارسال پیام به ربات تلگرام برای کاربر


        }else{
            // در صورتی که کاربر از قبل داخل سیستم ما ثبت نام نباشه، یک حساب کاربری برای اون فرد ایجاد می کنیم
            $password = 1234;
            $user = User::create([
                'facebook_id' => $userData['userid'], // از این فیلد برای ذخیره آی دی تلگرام خود فرد استفاده میشه
                'surname' => $userData['firstName'], // نام فرد در داخل این فیلد قرار داده میشه، این فیلد باید حتما مقدار داشته باشه
                'name' => '', // نام خانوادگی فرد در داخل این فیلد قرار داده میشه، این فیلد باید حتما مقدار داشته باشه
                'email' => $userData['userid'] . "@NevisaBot.com", // ایمیل کاربر داخل این فیلد ذخیره میشه
                'password' => Hash::make($password), // رمز عبور کاربر به صورت هش شده در داخل این فیلد ذخیره میشه
            ]);
                    
            if($user){
                $response = "شما با موفقیت در ربات ثبت نام شدید :))";
                
                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => $response,
                ];
                // ارسال پیام به ربات تلگرام برای کاربر
                sendMessageToTelegram($telegramSendMessageParams);
                die();
            }else{
                $response = "خطا در ثبت نام :((";

                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => $response,
                ];
                // ارسال پیام به ربات تلگرام برای کاربر
                sendMessageToTelegram($telegramSendMessageParams);
                die();
            }
        }
    }

    public function invitedLink(){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        // ایجاد متن لینک دعوت برای کاربر
        $invitedLink = "https://t.me/nevisa_ai_bot?start=" . $userData['chatId'];
        $invitedLink .= "\n\n\n" . 'با دعوت دوستاتون با این لینک میتونین اعتبار خود را افزایش دهید :))';

        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
        $telegramSendMessageParams = [
            'chat_id' => $userData['chatId'],
            'text' => $invitedLink
        ];
            
        // ارسال پیام به ربات تلگرام برای کاربر
        sendMessageToTelegram($telegramSendMessageParams);
        die();
    }

    // نمایش لیست پکیج های افزایش اعتبار
    public function packagesList() {
        $userData = getUserDataFromTelegram();

        // شمارنده برای پیدا بررسی این که به پایان حلقه رسیدیم یا نه
        $planCounter = 1;
        // شمارنده برای این که در هر سطر، تعداد آیتم های مدنظر خودمون رو بتونیم قرار بدیم
        $itemCounter = 1;
        $plans = Plan::where('active', 1)->get()->groupBy('name');
        /*************************** added by me **************************/
        $keyboard = [];
        foreach ($plans as $key => $value){
            $items[] = $key;
            // در هر بار اجرای حلقه، مقدار آیتم رو داخل آرایه keyboardItems قرار میدیم.
            $keyboardItems[] = $key;
            // در صورتی که تعداد آیتم ها به دو عدد رسید، یا به انتهای حلقه رسیده بودیم و تعداد آیتم ها از دو تا کمتر بود
            if($itemCounter == 2 || ($itemCounter<2 && count($plans) == $planCounter))
            {
                // مقدار قبلی آرایه keyboard رو با مقدار جدید به دست اومده ادغام کن
                $keyboard = array_merge($keyboard,[$keyboardItems]);
                // بعد از این که داخل آرایه اصلی قرار داده شد،، آرایه رو خالی کن
                $keyboardItems = [];
                // شمارنده تعداد آیتم ها رو به یک تغییر بده
                $itemCounter = 1;
            }else
            {
                $itemCounter++;
            }
            $planCounter++;
        }
        
        // در انتهای پیدا شدن کل دسته بندی ها، مقدار برگشت رو هم به صورت دستی به انتهای آرایه اضافه می کنیم
        $keyboard = array_merge($keyboard,[['Return']]);
        /*************************** end added by me **************************/
        sendMessageToTelegram([
            'chat_id' => $userData['chatId'],
            'text' => "لطفا برای افزایش اعتبار خود یکی از پکیج های زیر را برای خرید انتخاب کنید (¬‿¬)",
                'reply_markup' => json_encode([
                'keyboard' => $keyboard,
                'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
            ])
        ]);

        die();
    }

    public function packageDetails($packageName) {
        $userData = getUserDataFromTelegram();
        $plan = Plan::where('name', $packageName)->first();
        $paymentLink = new PaymentController();
        $details = $plan->name;
        $details .= "\n\n قیمت پکیج : " . $plan->price;
        $details .= "\n\n میزان اعتبار : " . $plan->description;
        $details .= "\n\nاگر مایل به خرید این پکیج هستید روی ادامه و پرداخت کلیک کنید و وارد درگاه شوید ಥ_ಥ ";

        $params['packageName'] = $packageName;

//        sendMessageToTelegram([
//            'chat_id' => $userData['chatId'],
//            'text' =>' dasds',
//        ]);
//        die();
         $keyboard = [
             'inline_keyboard' => [
                 [
                     ['text' => 'ادامه و پرداخت', 'url' => $paymentLink->generatePaymentLink($params)],
                     ['text' => 'لغو', 'callback_data' => 'back_page']
                 ]
             ]
         ];
        
        /**************************** added by me ***************************/
        // $keyboard = 
        // [
        //     [
        //         ['text' => 'ادامه و پرداخت', 'url' => $paymentLink->generatePaymentLink($params)],
        //         ['text' => 'لغو', 'callback_data' => 'back_page']
        //     ]
        // ];
        
        // $replyMarkup = Keyboard::make([
        //     'inline_keyboard' => $keyboard
        // ]);

//        $keyboard = [
//            'inline_keyboard' => [
//                [
//                    ['text' => 'ادامه و پرداخت', 'url' => $paymentLink->generatePaymentLink($params)],
//                    ['text' => 'لغو', 'callback_data' => 'back_page']
//                ]
//            ]
//        ];

//        sendMessageToTelegram([
//            'chat_id' => $userData['chatId'],
//            'text' => $details,
//            'reply_markup' => $replyMarkup,
//        ]);
        /**************************** end added by me ***************************/

         sendMessageToTelegram([
             'chat_id' => $userData['chatId'],
             'text' => $details,
             'reply_markup' => json_encode($keyboard),
         ]);
    }

    public function showProfile(){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        // بررسی می کنیم که کاربری با آی دی دریافت شده در داخل دیتابیس وجود داره
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first();
        // دریافت اطلاعات تمام پرامپت ها
        $userOpenAiAll = UserOpenai::where('user_id', $user->id)->get();
        // دریافت اطلاعات پرامپت های تایید شده
        $userOpenAiAceepted = UserOpenai::where('user_id', $user->id)->where('status', 'APPROVE')->get();
        // دریافت اطلاعات پرامپت های کنسل شده
        $userOpenAiCanceled = UserOpenai::where('user_id', $user->id)->where('status', 'CANCEL')->get();

        // ایجاد اطلاعات پروفایل کاربری برای ارسال به ربات تلگرام برای نمایش به کاربر
        $showInfo = '***اطلاعات پروفایل***' . "\n\n";
        $showInfo .= 'نام : ' . $user->surname . "\n\n";
        $showInfo .= 'نام کاربری : ' . $userData['username'] . "\n\n";
        $showInfo .= 'تلفن : ' . $user->phone . "\n\n";
        $showInfo .= 'وضعیت اعتبار : '  . "\n\n";

        $keyboard = [
            ['ویرایش تلفن', 'ویرایش نام'],
            ['مشاهده پرامت ها'],
            ['حذف حساب کاربری'],
            ['تنظیمات پرامت'],
            ['Return'],
        ];

        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
        $telegramSendMessageParams = [
            'chat_id' => $userData['chatId'],
            'text' => $showInfo, // اطلاعات پروفایل کاربر
            'reply_markup' => json_encode([
                'keyboard' => $keyboard, // لیست دکمه هایی که به کاربر نمایش داده میشه
                'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
            ])
        ];
        // ارسال پیام به ربات تلگرام برای کاربر
        sendMessageToTelegram($telegramSendMessageParams);
    }

    public function promptSetting() {
        $userData = getUserDataFromTelegram();

        $keyboard = [
            ['زبان', 'لحن'],
            ['نسخه هوش مصنوعی'],
            ['Return'],
        ];

        sendMessageToTelegram([
            'chat_id' => $userData['chatId'],
            'text' => 'Setting',
            'reply_markup' => json_encode([
                'keyboard' => $keyboard, // لیست دکمه هایی که به کاربر نمایش داده میشه
                'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
            ])
        ]);
    }
    
    public function editDefultePromptSetting($message) {
        $userData = getUserDataFromTelegram();

        switch ($message) {
            case 'لحن' :
                $keyboard = [
                    'inline_keyboard' => [
                        [
                            ['text' => 'رسمی', 'callback_data' => 'Professional'],
                            ['text' => 'خنده دار', 'callback_data' => 'Funny'],
                            ['text' => 'تصادفی', 'callback_data' => 'Casual'],
                        ],
                        [
                            ['text' => 'هیجان زده', 'callback_data' => 'Excited'],
                            ['text' => 'شوخ', 'callback_data' => 'Witty'],
                            ['text' => 'طعنه آمیز', 'callback_data' => 'Sarcastic'],
                        ],
                        [
                            ['text' => 'زنانه', 'callback_data' => 'Feminine'],
                            ['text' => 'مردانه', 'callback_data' => 'Masculine'],
                            ['text' => 'اغراق آمیز', 'callback_data' => 'Bold'],
                        ],
                        [
                            ['text' => 'دراماتیک', 'callback_data' => 'Dramatic'],
                            ['text' => 'بدخلق', 'callback_data' => 'Grumpy'],
                            ['text' => 'رازدار', 'callback_data' => 'Secretive'],
                        ],
                        [
                            ['text' => 'لغو', 'callback_data' => 'cancel']
                        ]
                    ]
                ];

                sendMessageToTelegram([
                    'chat_id' => $userData['chatId'],
                    'text' => 'مقدار پیشفرض لحن : رسمی' . "\n\n اگر مایل ب تغییر مقدار پیشفرض هستید یکی از لحن های زیر را انتخاب منید (•_•)",
                    'reply_markup' => json_encode($keyboard),
                ]);
                break;
            case 'زبان' :
                $keyboard = [
                    'inline_keyboard' => [
                        [
                            ['text' => 'انگلیسی(آمریکایی)', 'callback_data' => 'en-US'],
                            ['text' => 'فارسی', 'callback_data' => 'fa_IR'],
                        ],
                        [
                            ['text' => 'عربی', 'callback_data' => 'ar-AE'],
                        ],
                        [
                            ['text' => 'لغو', 'callback_data' => 'cancel']
                        ]
                    ]
                ];

                sendMessageToTelegram([
                    'chat_id' => $userData['chatId'],
                    'text' => 'مقدار پیشفرض زبان : فارسی' . "\n\n اگر مایل ب تغییر مقدار پیشفرض هستید یکی از زبان های زیر را انتخاب منید (•_•)",
                    'reply_markup' => json_encode($keyboard),
                ]);
                break;
            case 'نسخه هوش مصنوعی' :
                $keyboard = [
                    'inline_keyboard' => [
                        [
                            ['text' => 'gpt_4o', 'callback_data' => 'gpt_4o'],
                            ['text' => 'gpt_4o_mini', 'callback_data' => 'gpt_4o_mini'],
                        ],
                        [
                            ['text' => 'لغو', 'callback_data' => 'cancel']
                        ]
                    ]
                ];

                sendMessageToTelegram([
                    'chat_id' => $userData['chatId'],
                    'text' => 'مقدار پیشفرض نسخه هوش مصنوعی : gpt_4o' . "\n\n اگر مایل ب تغییر مقدار پیشفرض هستید یکی از نسخه های زیر را انتخاب منید (•_•)",
                    'reply_markup' => json_encode($keyboard),
                ]);
                break;
        }
    }

    // متد soft delete اکانت کاربری از دیتابیس سایت
    public function approveDeleteAccount(){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        // دریافت اطلاعات کاربر از داخل دیتابیس
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first();

        // گذاشتن اکانت کاربر در حالت soft delete
        $user->update([
            'status' => 0
        ]);

        $keyboard = [
            ['بله', 'خیر'],
        ];

        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
        $telegramSendMessageParams = [
            'chat_id' => $userData['chatId'],
            'text' => 'اگر از حذف حساب کاربری خود اطمینان دارید روی گزینه (بله) کلیک کنید ^_^',
            'reply_markup' => json_encode([
                'keyboard' => $keyboard,
                'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
            ])
        ];
        // ارسال پیام به ربات تلگرام برای کاربر
        sendMessageToTelegram($telegramSendMessageParams);
    }

    public function deleteAccount($answer){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        // پیدا کردن اطلاعات حساب کاربری در دیتابیس
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first();

        switch($answer){
            case 'بله' :
                $user->update([
                    'affiliate_status' => 2
                ]);
                
                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => 'حساب کاربری شما با موفقیت حذف شد ;-)',
                    'reply_markup' => json_encode([
                            'remove_keyboard' => true,
                    ])  
                ];
                // ارسال پیام به ربات تلگرام برای کاربر
                sendMessageToTelegram($telegramSendMessageParams);
            break;
            case 'خیر' :
                $user->update([
                    'status' => 1,
                    'affiliate_status' => 1
                ]);
                
                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => 'درخواست شما لفو گردید (T_T)',
                    'reply_markup' => json_encode([
                        'remove_keyboard' => true,
                    ])  
                ];
                // ارسال پیام به ربات تلگرام برای کاربر
                sendMessageToTelegram($telegramSendMessageParams);
            break;
        }
    }

    public function editProfile($data){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        // دریافت اطلاعات کاربر درخواست دهنده
        $user = User::where('facebook_id' ,$userData['userid'])->where('affiliate_status', 1)->first();

        switch($data){
            case "ویرایش نام" :
                // برای این که موقع ارسال مقادیر از سمت کاربر متوجه بشیم که کدوم پارامتر باید ویرایش بشه، وضعیت رو تغییر میدیم
                $userUpdate = $user->update([
                    'status' => 2
                ]);

                if($userUpdate){
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => 'لطفا نام جدید خود را وارد کنید : '
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);

                }else{
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => 'invalid'
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                }

                break;
            case "ویرایش تلفن" :
                
                // برای این که موقع ارسال مقادیر از سمت کاربر متوجه بشیم که کدوم پارامتر باید ویرایش بشه، وضعیت رو تغییر میدیم
                $userUpdate = $user->update([
                    'status' => 3
                ]);

                if($userUpdate){
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => 'لطفا شماره تلفن خود را وارد کنید :'
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);

                }else{
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => 'invalid'
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                }
               
                break;
            // case "ویرایش ایمیل" :

            //     $userUpdate = $user->update([
            //         'status' => 4
            //     ]);

            //     if($userUpdate){
            //         $telegram->sendMessage([
            //             'chat_id' => $chatId,
            //             'text' => 'لطفا ایمیل خود را وارد کنید :'
            //         ]);

            //     }else{
            //         $telegram->sendMessage([
            //             'chat_id' => $chatId,
            //             'text' => 'invalid'
            //         ]);
            //     }
               

                
            //     break;
        }
    }

    public function updateNameProfile($info){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        // دریافت اطلاعات کاربر درخواست دهنده
        $user = User::where('facebook_id' ,$userData['userid'])->where('affiliate_status', 1)->first();
        
        $userUpdate = $user->update([
            'surname' => $info,
            'status' => 1
        ]);

        if($userUpdate){
            $this->showProfile();
        }else{
            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
            $telegramSendMessageParams = [
                'chat_id' => $userData['chatId'],
                'text' => 'invalid'
            ];
            // ارسال پیام به ربات تلگرام برای کاربر
            sendMessageToTelegram($telegramSendMessageParams);
        }
    }

    public function updatePhoneProfile($info){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        // دریافت اطلاعات کاربر درخواست دهنده
        $user = User::where('facebook_id' ,$userData['userid'])->where('affiliate_status', 1)->first();
        
        $userUpdate = $user->update([
            'phone' => $info,
            'status' => 1
        ]);

        if($userUpdate){
            $this->showProfile();
        }else{
            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
            $telegramSendMessageParams = [
                'chat_id' => $userData['chatId'],
                'text' => 'invalid'
            ];
            // ارسال پیام به ربات تلگرام برای کاربر
            sendMessageToTelegram($telegramSendMessageParams);
        }
    }

    public function updateEmailProfile($info){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        // دریافت اطلاعات کاربر درخواست دهنده
        $user = User::where('facebook_id' ,$userData['userid'])->where('affiliate_status', 1)->first();
        
        $userUpdate = $user->update([
            'email' => $info,
            'status' => 1
        ]);

        if($userUpdate){
            $this->showProfile();
        }else{
            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
            $telegramSendMessageParams = [
                'chat_id' => $userData['chatId'],
                'text' => 'invalid'
            ];
            // ارسال پیام به ربات تلگرام برای کاربر
            sendMessageToTelegram($telegramSendMessageParams);
        }
    }

    public function categoryMessage(){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        $action = "لطفا یکی از فیلتر های (دسته بندی های) زیر را انتخاب کنید ";
        
        // دریافت لیست فیلترهای پرامپت هوش مصنوعی
        $openAIFilters = OpenAIGenerator::where('prompt', '!=' ,null)->get()->groupBy('filters');
        foreach($openAIFilters as $key => $value){
            $filter[] = $key;
        }

        $keyboard = [
           [$filter[0], $filter[1]],
           [$filter[2], $filter[3]],
           ['Return'],
        ];

        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
        $telegramSendMessageParams = [
            'chat_id' => $userData['chatId'],
            'text' => $action,
            'reply_markup' => json_encode([
                'keyboard' => $keyboard,
                'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
            ])
        ];
        // ارسال پیام به ربات تلگرام برای کاربر
        sendMessageToTelegram($telegramSendMessageParams);
    }

    public function promptList(){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        // دریافت اطلاعات کاربر از دیتابیس
        $user = User::where('facebook_id', $userData['chatId'])->where('affiliate_status', 1)->first();
        $userOpenAi = UserOpenai::where('user_id', $user->id)->get();

        if(count($userOpenAi) > 0){
            foreach($userOpenAi as $key => $value){
                $openAi = OpenAIGenerator::where('id' , $value->openai_id)->first(); 
                $showInfo = 'Id = ' . $value->id . "\n";
                $showInfo .= 'Title = ' . $openAi->title . "\n";
                $showInfo .= 'Status = ' . $value->status . "\n";
    
                // $keyboard = [
                //     // ['Delete'],
                //     ['Return'],
                // ];
    
                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                $telegramSendMessageParams = [
                    'chat_id' => $userData['chatId'],
                    'text' => $showInfo,
                //     'reply_markup' => json_encode([
                //     'keyboard' => $keyboard,
                //     'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                //     'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                // ])
                ];
                // ارسال پیام به ربات تلگرام برای کاربر
                sendMessageToTelegram($telegramSendMessageParams);
                
            }
        }elseif(count($userOpenAi) == 0){
            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
            $telegramSendMessageParams = [
                'chat_id' => $userData['chatId'],
                'text' => 'هنوز هیچ پرامتی ثبت نشده است 🥱',
            ];
            // ارسال پیام به ربات تلگرام برای کاربر
            sendMessageToTelegram($telegramSendMessageParams);
        }
    }

    // public function deletePrompt($promptId){
    //     $telegram = new Api(env('TELEGRAM_BOT_API_TOKEN'));
    //     $update = $telegram->getWebhookUpdate();
    //     $chatId = $update->getMessage()->getChat()->getId();

    //     $userOpenAi = UserOpenai::where('id', $promptId)->first();

    //     if($userOpenAi != null){
    //         $delete = $userOpenAi->delete();

    //         if($delete){
    //             $telegram->sendMessage([
    //                 'chat_id' => $chatId,
    //                 'text' => 'پرامت شما با موفقیت حذف شد.'
    //             ]);
    //             exit();
    //         }else{
    //             $telegram->sendMessage([
    //                 'chat_id' => $chatId,
    //                 'text' => 'incalid data !!!'
    //             ]);
    //             exit();
    //         }
    //         exit();
    //     }else{
    //         $telegram->sendMessage([
    //             'chat_id' => $chatId,
    //             'text' => 'ایدی مورد نظر شما یافت نشد !!!'
    //         ]);
    //         exit();
    //     }

    // }

    public function titleOfCategory($filter)
    {
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        $action = "خب حالا شما باید یکی از عنوان های زیر را برای پرامت خود انتخاب کنید :))";
        
        // $openAIFilters = OpenAIGenerator::where('filters', $filter)->get()->groupBy('title');
        $openAi = OpenAIGenerator::where('filters', $filter)->where('prompt', '!=' ,null)->get()->groupBy('title');

        foreach($openAi as $key => $value){
            $title[] = $key;
        }

        $keyboard = [ 
            [
                isset($title[0]) ? $title[0] : '',
                isset($title[1]) ? $title[1] : ''
            ],
           
            [
                isset($title[2]) ? $title[2] : '',
                isset($title[3]) ? $title[3] : ''
            ],
           
            [
                isset($title[4]) ? $title[4] : '',
                isset($title[5]) ? $title[5] : ''
            ],
           
            [
                isset($title[6]) ? $title[6] : '',
                isset($title[7]) ? $title[7] : ''
            ],
            ['Back'],
            ['Return'],
        ];
    
        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
        $telegramSendMessageParams = [
            'chat_id' => $userData['chatId'],
            'text' => $action,
            'reply_markup' => json_encode([
                'keyboard' => $keyboard,
                'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
            ])
        ];
        // ارسال پیام به ربات تلگرام برای کاربر
        sendMessageToTelegram($telegramSendMessageParams);
    }

    public function getTitle($title)
    {
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();

        // دریافت عنوان درخواستی هوش مصنوعی از دیتابیس
        $openAITitle = OpenAIGenerator::where('title', $title)->first();

        // دریافت لیست پارامترهای مورد نیاز برای سوال از دیتابیس
        $openAIQuestions = json_decode($openAITitle->questions);

        // دریافت اطلاعات کاربر از دیتابیس
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first();
        
        // دریافت آخرین سوال درخواست شده کاربر از هوش مصنوعی با عنوان سوال درخواست شده
        $userOpenai = UserOpenai::where('openai_id', $openAITitle->id)->where('user_id', $user->id)->latest()->first();

        
        $index = 0;
        // در صورتی که با سوال درخواست شده، از قبل درخواستی برای کاربر وجود نداشته باشه اون رو ایجاد می کنیم
        if(!$userOpenai){
            $createUserOpenai = UserOpenai::create([
                'openai_id' => $openAITitle->id,
                'user_id' => $user->id,
                'credits' => $index,
                'status' => 0
            ]);
            
            // مقدار هر کدام از پارامترهای مورد نیاز برای سوال رو از کاربر می گیریم
            foreach($openAIQuestions as $key => $value){
                if($index == $key){
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => $index . '. ' . "Please enter a " . $value->question,
                        'reply_markup' => json_encode([
                            'remove_keyboard' => true,
                        ])  
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                }
            }

            exit();
        }else{
            if(count($openAIQuestions) > 1 && count($userOpenai->input) != count($openAIQuestions) && $userOpenai->status == 0){
                
                $index = $userOpenai->credits;
                $index++;
                foreach($openAIQuestions as $key => $value){
                    if($index == $key){
                        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                        $telegramSendMessageParams = [
                            'chat_id' => $userData['chatId'],
                            'text' => $index . '. ' . "Please enter a " . $value->question,
                        ];
                        // ارسال پیام به ربات تلگرام برای کاربر
                        sendMessageToTelegram($telegramSendMessageParams);
                    } 
                }
                $userOpenai->update([
                    'credits' => $index,
                ]);
                die();  
            }
            elseif($userOpenai->status == "APPROVE" || $userOpenai->status == "CANCEL"){

                $createUserOpenai = UserOpenai::create([
                    'openai_id' => $openAITitle->id,
                    'user_id' => $user->id,
                    'credits' => $index,
                    'status' => 0
                ]);
                
                if($createUserOpenai){
                    foreach($openAIQuestions as $key => $value){
                        if($index == $key){
                            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                            $telegramSendMessageParams = [
                                'chat_id' => $userData['chatId'],
                                'text' => $index . '. ' . "Please enter a " . $value->question,
                                'reply_markup' => json_encode([
                                    'remove_keyboard' => true,
                                ])  
                            ];
                            // ارسال پیام به ربات تلگرام برای کاربر
                            sendMessageToTelegram($telegramSendMessageParams);
                        }
                    }
                }
            }//elseif($userOpenai->status == "UPDATING"){
            //     $keyboard = [
            //         ['Edit', 'Accept'],
            //         ['Cancel']
            //     ];

                // // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                // $telegramSendMessageParams = [
                //     'chat_id' => $userData['chatId'],
                //     'text' => "اگر مایل ب تکمیل شدن پرامت خود هستید روی تایید کلیک کنید :))",
                //     'reply_markup' => json_encode([
                //         'keyboard' => $keyboard,
                //         'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                //         'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                //     ])  
                // ];
                // // ارسال پیام به ربات تلگرام برای کاربر
                // sendMessageToTelegram($telegramSendMessageParams);

            // }

        }
    }

    public function getData($Data){

        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first(); 
        $userOpenai = UserOpenai::where('user_id', $user->id)->where('status', 0)->latest()->first();
        $openAITitle = OpenAIGenerator::where('id', $userOpenai->openai_id)->first();

        $openAIQuestions = json_decode($openAITitle->questions);

        
        if($userOpenai){
            
            $openAITitle = OpenAIGenerator::where('id', $userOpenai->openai_id)->first();
            
            $openAIQuestions = json_decode($openAITitle->questions);
            
            if(count($openAIQuestions) > 1){
                if($userOpenai->input == null){
                    $text[] = [
                        $openAIQuestions[0]->name => $Data
                    ];


                    $userOpenai->update([
                        'input' => $text,
                    ]);
                    
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => "Done :)",
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    
                    // $telegram->sendMessage([
                    //     'chat_id' => $userData['chatId'],
                    //     'text' => $userOpenai->openai_id,
                    // ]);
                    // die();  

                    $this->getTitle($openAITitle->title);
                    exit();
                }else{
                    if(!empty($userOpenai->input) && count($userOpenai->input) != count($openAIQuestions)){

                        foreach($userOpenai->input as $key => $value){
                            $newData[] = $value;
                        }

                        $item = $openAIQuestions[$userOpenai->credits]->name;
                        $newData[$userOpenai->credits] = [$item => $Data];

                            $userOpenai->update([
                                'input' => $newData,
                            ]);

                            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                            $telegramSendMessageParams = [
                                'chat_id' => $userData['chatId'],
                                'text' => "Done :)",
                            ];
                            // ارسال پیام به ربات تلگرام برای کاربر
                            sendMessageToTelegram($telegramSendMessageParams);

                            if(count($userOpenai->input) == count($openAIQuestions)){
                                $userOpenai->update([
                                    'status' => "PENDING...",
                                ]);
                                
                                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                                $telegramSendMessageParams = [
                                    'chat_id' => $userData['chatId'],
                                    'text' => 'اطالاعات شما با موفقیت وارد شده است :))',
                                ];
                                // ارسال پیام به ربات تلگرام برای کاربر
                                sendMessageToTelegram($telegramSendMessageParams);


                                $preview = "نتیجه اطلاعات شما : \n";
                                foreach($userOpenai->input as $key => $value){
                                    foreach($value as $title => $data){
                                        $preview .= $title . " => " . $data . "\n";
                                    }
                                }
                                
                                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                                $telegramSendMessageParams = [
                                    'chat_id' => $userData['chatId'],
                                    'text' => $preview,
                                ];
                                // ارسال پیام به ربات تلگرام برای کاربر
                                sendMessageToTelegram($telegramSendMessageParams);
                                
                                $keyboard = [
                                    ['Edit', 'Accept'],
                                    ['Cancel']
                                ];

                                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                                $telegramSendMessageParams = [
                                    'chat_id' => $userData['chatId'],
                                    'text' => "اگر مایل ب تکمیل شدن پرامت خود هستید روی تایید کلیک کنید :))",
                                    'reply_markup' => json_encode([
                                        'keyboard' => $keyboard,
                                        'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                                        'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                                    ])
                                ];
                                // ارسال پیام به ربات تلگرام برای کاربر
                                sendMessageToTelegram($telegramSendMessageParams);
    
                            }else{
                                $this->getTitle($openAITitle->title);
                            }

                    }else{
                        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                        $telegramSendMessageParams = [
                            'chat_id' => $userData['chatId'],
                            'text' => "شما قبلا این بخش را کامل کرده اید !!!",
                        ];
                        // ارسال پیام به ربات تلگرام برای کاربر
                        sendMessageToTelegram($telegramSendMessageParams);
                    }
                    exit();   
                }

            }else{
                foreach($openAIQuestions as $openAIQuestion){
                    $text[] = [
                        $openAIQuestion->name => $Data,
                    ];
                }
                
                $userOpenai->update([
                    'status' => "PENDING...",
                    'input' => $text,
                ]);
                
                if($userOpenai){

                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => "اطلاعات شما با موفقیت وارد شده است :))",
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    
                    $preview = "نتیجه اطلاعات شما : \n";
                    foreach($userOpenai->input as $key => $value){
                        foreach($value as $title => $data){
                            $preview .= $title . " => " . $data . "\n";
                        }
                    }
                    
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => $preview,
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    
                    $keyboard = [
                        ['Edit', 'Accept'],
                        ['Cancel']
                    ];
            
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => 'اگر مایل ب تکمیل شدن پرامت خود هستید روی تایید کلیک کنید :))',
                        'reply_markup' => json_encode([
                            'keyboard' => $keyboard,
                            'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                            'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                        ])
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    die();
                }else{
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => "GoodBye",
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    die();
                }
            }
        }else{
            // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
            $telegramSendMessageParams = [
                'chat_id' => $userData['chatId'],
                'text' => "Wrong",
            ];
            // ارسال پیام به ربات تلگرام برای کاربر
            sendMessageToTelegram($telegramSendMessageParams);
        }
        die();
    }

    public function answer($answer){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first(); 
        $userOpenai = UserOpenai::where('user_id', $user->id)->where('status', 'PENDING...')->latest()->first();
        $openAI = OpenAIGenerator::where('id', $userOpenai->openai_id)->first();



        switch($answer){
            case "Accept":
                $userOpenai->update([
                    'response' => $openAI->description,
                    'output' => $openAI->description,
                    'status' => "APPROVE"
                ]);

                if($userOpenai){
                    $openAI = OpenAIGenerator::where('id', $userOpenai->openai_id)->first();
                    $preview = $openAI->prompt;
                    
                    foreach($userOpenai->input as $key => $value){
                        foreach($value as $name => $data){
                            $preview = str_replace("**$name**", $data, $preview);
                        }
                    }
                    
                    $message = "**پرامت شما با موفیت تکمیل شده است** \n\n";
                    $message .= 'پرامت شما  = ' . $preview;

                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => $message,
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
    
                    $userOpenai->update([
                        'payload' => $preview
                    ]);

                    $response = 'اطلاعات شما تایید شده و پرامت شده ارسال شده است :)';
                }else{
                    $response = 'invalid data !!!';
                }
            break;
            case "Cancel":
                $userOpenai->update([
                    'status' => "CANCEL"
                ]);

                if($userOpenai){
                    $this->startMessage($userData['userid']);
                }else{
                    $response = "Please try again :(";
                }
                
                break;
            case "Edit":
                $userOpenai->update([
                    'input' => null,
                    'credits' => null
                ]);
                if($userOpenai){
                    $this->editPrompt($openAI->title);
                    // $response = 'Successfuly';
                }else{
                    $response = 'Wrong';
                }
                break;
        }
                
        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
        $telegramSendMessageParams = [
            'chat_id' => $userData['chatId'],
            'text' => $response,
            'reply_markup' => json_encode([
                'remove_keyboard' => true,
            ])  
        ];
        // ارسال پیام به ربات تلگرام برای کاربر
        sendMessageToTelegram($telegramSendMessageParams);
    }
                
    public function editPrompt($title){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
                    
        $openAITitle = OpenAIGenerator::where('title', $title)->first();
                    
        $openAIQuestions = json_decode($openAITitle->questions);
                    
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first();
                    
        $userOpenai = UserOpenai::where('openai_id', $openAITitle->id)->where('user_id', $user->id)->latest()->first();
        $index = 0;
        if($userOpenai->input == null){
                        
            $userOpenai->update([
                'credits' => $index,
                'status' => "UPDATING"
            ]);
    
            foreach($openAIQuestions as $key => $value){
                if($index == $key){
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => $index . '. ' . "Please enter a " . $value->question,
                        'reply_markup' => json_encode([
                            'remove_keyboard' => true,
                        ])  
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                }
            }
            exit();
        }elseif(!empty($userOpenai->input)){
            if(count($openAIQuestions) > 1 && count($userOpenai->input) != count($openAIQuestions)){
                $index = $userOpenai->credits;
                $index++;
                foreach($openAIQuestions as $key => $value){
                    if($index == $key){
                        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                        $telegramSendMessageParams = [
                            'chat_id' => $userData['chatId'],
                            'text' => $index . '. ' . "Please enter a " . $value->question,
                        ];
                        // ارسال پیام به ربات تلگرام برای کاربر
                        sendMessageToTelegram($telegramSendMessageParams);
                    } 
                }
                $userOpenai->update([
                    'credits' => $index,
                ]);
                
                die();
            }
        }
    }

    public function updateUserOpenAiData($data){
        // دریافت لیست اطلاعات کاربر از تلگرام
        $userData = getUserDataFromTelegram();
        
        $user = User::where('facebook_id', $userData['userid'])->where('affiliate_status', 1)->first(); 
        $userOpenai = UserOpenai::where('user_id', $user->id)->where('status', 0)->latest()->first();
        $openAITitle = OpenAIGenerator::where('id', $userOpenai->openai_id)->first();

        $openAIQuestions = json_decode($openAITitle->questions);

        if($userOpenai){
            
            $openAITitle = OpenAIGenerator::where('id', $userOpenai->openai_id)->first();
            
            $openAIQuestions = json_decode($openAITitle->questions);
            
            if(count($openAIQuestions) > 1){
                if($userOpenai->input == null){
                    $text[] = [
                        $openAIQuestions[0]->name => $data
                    ];
                    
                    $userOpenai->update([
                        'input' => $text,
                    ]);
                    
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => "Done :)",
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                   
                    // $telegram->sendMessage([
                    //     'chat_id' => $chatId,
                    //     'text' => $userOpenai->openai_id,
                    // ]);
                    // die();  

                    $this->editPrompt($openAITitle->title);
                    exit();
                }else{
                    if(!empty($userOpenai->input) && count($userOpenai->input) != count($openAIQuestions)){

                        foreach($userOpenai->input as $key => $value){
                            $newData[] = $value;
                        }

                        $item = $openAIQuestions[$userOpenai->credits]->name;
                        $newData[$userOpenai->credits] = [$item => $data];
                        
                        $userOpenai->update([
                            'input' => $newData,
                        ]);
                        
                        // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                        $telegramSendMessageParams = [
                            'chat_id' => $userData['chatId'],
                            'text' => "Done :)",
                        ];
                        // ارسال پیام به ربات تلگرام برای کاربر
                        sendMessageToTelegram($telegramSendMessageParams);

                            

                            if(count($userOpenai->input) == count($openAIQuestions)){

                                $userOpenai->update([
                                    'status' => "PENDING...",
                                ]);
                                
                                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                                $telegramSendMessageParams = [
                                    'chat_id' => $userData['chatId'],
                                    'text' => 'اطالاعات شما با موفقیت بروزرسانی شد :))',
                                ];
                                // ارسال پیام به ربات تلگرام برای کاربر
                                sendMessageToTelegram($telegramSendMessageParams);


                                $preview = "نتیجه اطلاعات شما : \n";
                                foreach($userOpenai->input as $key => $value){
                                    foreach($value as $title => $info){
                                        $preview .= $title . " => " . $info . "\n";
                                    }
                                }
                                
                                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                                $telegramSendMessageParams = [
                                    'chat_id' => $userData['chatId'],
                                    'text' => $preview,
                                ];
                                // ارسال پیام به ربات تلگرام برای کاربر
                                sendMessageToTelegram($telegramSendMessageParams);
                                
                                $keyboard = [
                                    ['Edit', 'Accept'],
                                    ['Cancel']
                                ];

                                // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                                $telegramSendMessageParams = [
                                    'chat_id' => $userData['chatId'],
                                    'text' => "اگر مایل ب تکمیل شدن پرامت خود هستید روی تایید کلیک کنید :))",
                                    'reply_markup' => json_encode([
                                        'keyboard' => $keyboard,
                                        'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                                        'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                                    ])
                                ];
                                // ارسال پیام به ربات تلگرام برای کاربر
                                sendMessageToTelegram($telegramSendMessageParams);
    
                            }else{
                                
                                $this->editPrompt($openAITitle->title);
                            }

                    }
                }
            }else{
                
                foreach($openAIQuestions as $openAIQuestion){
                    $text[] = [
                        $openAIQuestion->name => $data,
                    ];
                }
                
                $userOpenai->update([
                    'status' => "PENDING...",
                    'input' => $text,
                ]);
                
                if($userOpenai){
                    
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => "اطالاعات شما با موفقیت بروزرسانی شد :))",
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    
                    $preview = "نتیجه اطلاعات شما : \n";
                    foreach($userOpenai->input as $key => $value){
                        foreach($value as $title => $info){
                            $preview .= $title . " => " . $info . "\n";
                        }
                    }
                    
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => $preview,
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    
                    $keyboard = [
                        ['Edit', 'Accept'],
                        ['Cancel']
                    ];
            
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => 'اگر مایل ب تکمیل شدن پرامت خود هستید روی تایید کلیک کنید :))',
                        'reply_markup' => json_encode([
                            'keyboard' => $keyboard,
                            'resize_keyboard' => true, // تنظیم اندازه کیبورد برای سازگاری با صفحه نمایش
                            'one_time_keyboard' => true // پنهان کردن کیبورد بعد از انتخاب دکمه
                        ])
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    die();
                }else{
                    // پارامترهایی که برای ارسال پیام به تلگرام کاربر نیاز هست
                    $telegramSendMessageParams = [
                        'chat_id' => $userData['chatId'],
                        'text' => "GoodBye",
                    ];
                    // ارسال پیام به ربات تلگرام برای کاربر
                    sendMessageToTelegram($telegramSendMessageParams);
                    die();
                }
            }
        }
    }
} 
