<?php
    use Telegram\Bot\Api;

    if (!function_exists('getUserDataFromTelegram')) {
        function getUserDataFromTelegram(){
            $telegramGetMessageData = new Api(env('TELEGRAM_BOT_API_TOKEN'));
            $telegramGetMessageData = $telegramGetMessageData->getWebhookUpdate()->getMessage();
            
            if($telegramGetMessageData)
            {
                return array(
                    'userid'    => $telegramGetMessageData->getFrom()->getId(),
                    'username'  => $telegramGetMessageData->getFrom()->getUsername(),
                    'firstName' => $telegramGetMessageData->getFrom()->getFirstName(),
                    'lastName'  => $telegramGetMessageData->getFrom()->getLastName(),
                    'chatId'    => $telegramGetMessageData->getChat()->getId(),
                    'text'    => $telegramGetMessageData->getText(),
                );
            }else
            {
                echo json_encode(array('code' => 0,'message' => 'user data does not exists!'));
                exit();
            }
            
        }
    }

    if (!function_exists('sendMessageToTelegram')) {
        function sendMessageToTelegram($params)
        {
            // دریافت نمونه ایجاد شده از کلاس api
            $telegram = new Api(env('TELEGRAM_BOT_API_TOKEN'));
            // ارسال پیام به تلگرام برای کاربر
            $telegram->sendMessage($params);
            return true;
        }
    }