<?php

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Http;

    // چک کردن عضو بودن کاربر در چنل
    if (!function_exists('isUserMember')) {
    function isUserMember($userId)
{
    $userData = getUserDataFromTelegram();

    $telegramToken = env('TELEGRAM_BOT_API_TOKEN');
    $channelId = -1002495756788;

    $response = Http::get("https://api.telegram.org/bot$telegramToken/getChatMember", [
        'chat_id' => $channelId,
        'user_id' => $userId,
    ]);

    $result = $response->json();
//
    if (isset($result['result']['status']) && in_array($result['result']['status'], ['member', 'administrator', 'creator'])) {
        return true; // عضو است
    }
    return false;

}
    }
    // ارسال پبام برای عضویت در کانال
    if (!function_exists('sendToAsk')) {
        function sendToAsk($chatId)
        {
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => 'عضویت در کانال', 'url' => "https://t.me/nevisaai"],
                        ['text' => 'بررسی عضویت', 'callback_data' => 'check_membership']
                    ]
                ]
            ];
            sendMessageToTelegram([
                'chat_id' => $chatId,
                'text' => "برای استفاده از امکانات ربات، ابتدا در کانال ما عضو شوید.",
                'reply_markup' => json_encode($keyboard),
            ]);


            die();
        }
    }
    // هندل کردن عضورت در چنل تلگرام
        if (!function_exists('handleForCheckSubscribers')) {
            function handleForCheckSubscribers(Request $request)
            {
//

                $telegramToken = env('TELEGRAM_BOT_API_TOKEN');
                $channelId = -1002495756788;

                $userData = getUserDataFromTelegram();

                $data = $request->all();
                // بررسی نوع پیام دریافتی
                if ($userData) {
                    // بررسی عضویت کاربر
                    if (!isUserMember($userData['chatId'])) {
                        sendToAsk($userData['chatId']);
                        return;
                    }
                }

                // هندل Callback Queries
                if (isset($data['callback_query'])) {
                    $chatId = $data['callback_query']['message']['chat']['id'];
                    $callbackData = $data['callback_query']['data'];

                    if ($callbackData === 'check_membership') {
                        if (isUserMember($chatId)) {
                            sendMessageToTelegram([
                                'chat_id' => $userData['chatId'],
                                'text' => "شما عضو کانال هستید!",
                            ]);
                            die();
                            // ادامه عملیات
                        } else {
                            sendToAsk($userData['chatId']);
                        }
                    }
                }

            }
        }